/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.svg;

import com.tinyline.svg.SVG;
import com.tinyline.svg.SVGDocument;
import com.tinyline.svg.SVGGradientElem;
import com.tinyline.svg.SVGRaster;
import com.tinyline.tiny2d.TinyColor;
import com.tinyline.tiny2d.TinyMatrix;
import com.tinyline.tiny2d.TinyNumber;
import com.tinyline.tiny2d.TinyPoint;
import com.tinyline.tiny2d.TinyRect;
import com.tinyline.tiny2d.TinyString;
import com.tinyline.tiny2d.TinyTransform;
import com.tinyline.tiny2d.TinyVector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SVGNode {
    public int helem;
    public SVGDocument ownerDocument;
    public SVGNode parent;
    public TinyVector children;
    public TinyVector animatedVals;
    public TinyString id;
    public int xmlSpace;
    public TinyColor color;
    public TinyColor fill;
    public int fillRule;
    public TinyColor stroke;
    public int[] strokeDashArray;
    public int strokeDashOffset;
    public int strokeLineCap;
    public int strokeLineJoin;
    public int strokeMiterLimit;
    public int strokeWidth;
    public int visibility;
    public int display;
    public TinyString fontFamily;
    public int fontSize;
    public int fontStyle;
    public int fontWeight;
    public int textAnchor;
    public int fillOpacity;
    public int stopOpacity;
    public int strokeOpacity;
    public int opacity;
    public TinyColor stopColor;
    public TinyTransform transform;
    TinyString do;
    TinyString if;
    TinyString a;
    public TinyRect bounds;
    public boolean outlined;

    public SVGNode() {
        this.helem = 35;
        this.ownerDocument = null;
        this.parent = null;
        this.children = new TinyVector(4);
        this.id = null;
        this.animatedVals = new TinyVector(4);
        this.xmlSpace = 18;
        this.color = TinyColor.INHERIT;
        this.fill = TinyColor.INHERIT;
        this.fillRule = 26;
        this.stroke = TinyColor.INHERIT;
        this.stopColor = TinyColor.INHERIT;
        this.strokeDashArray = SVG.VAL_STROKEDASHARRAYINHERIT;
        this.strokeDashOffset = Integer.MIN_VALUE;
        this.strokeLineCap = 26;
        this.strokeLineJoin = 26;
        this.strokeMiterLimit = Integer.MIN_VALUE;
        this.strokeWidth = Integer.MIN_VALUE;
        this.stopOpacity = Integer.MIN_VALUE;
        this.strokeOpacity = Integer.MIN_VALUE;
        this.fillOpacity = Integer.MIN_VALUE;
        this.opacity = Integer.MIN_VALUE;
        this.visibility = 26;
        this.display = 26;
        this.fontFamily = null;
        this.fontSize = Integer.MIN_VALUE;
        this.fontStyle = 26;
        this.fontWeight = 26;
        this.textAnchor = 26;
        this.transform = new TinyTransform();
    }

    public SVGNode(SVGNode sVGNode) {
        this.helem = sVGNode.helem;
        this.ownerDocument = sVGNode.ownerDocument;
        this.parent = null;
        this.id = null;
        this.children = new TinyVector(4);
        int n = sVGNode.children.count;
        int n2 = 0;
        while (n2 < n) {
            SVGNode sVGNode2 = (SVGNode)sVGNode.children.data[n2];
            if (sVGNode2 != null) {
                this.addChild(sVGNode2.copyNode(), -1);
            }
            ++n2;
        }
        this.animatedVals = new TinyVector(4);
        this.color = sVGNode.color.copyColor();
        this.fill = sVGNode.fill.copyColor();
        this.fillRule = sVGNode.fillRule;
        this.stroke = sVGNode.stroke.copyColor();
        this.stopColor = sVGNode.stopColor.copyColor();
        if (sVGNode.strokeDashArray != null) {
            this.strokeDashArray = sVGNode.strokeDashArray;
            this.strokeDashArray = new int[sVGNode.strokeDashArray.length];
            System.arraycopy(sVGNode.strokeDashArray, 0, this.strokeDashArray, 0, this.strokeDashArray.length);
        }
        this.strokeDashOffset = sVGNode.strokeDashOffset;
        this.strokeLineCap = sVGNode.strokeLineCap;
        this.strokeLineJoin = sVGNode.strokeLineJoin;
        this.strokeMiterLimit = sVGNode.strokeMiterLimit;
        this.strokeWidth = sVGNode.strokeWidth;
        this.fillOpacity = sVGNode.fillOpacity;
        this.stopOpacity = sVGNode.stopOpacity;
        this.strokeOpacity = sVGNode.strokeOpacity;
        this.opacity = sVGNode.opacity;
        this.visibility = sVGNode.visibility;
        this.display = sVGNode.display;
        if (sVGNode.fontFamily != null) {
            this.fontFamily = new TinyString(sVGNode.fontFamily.data);
        }
        this.fontSize = sVGNode.fontSize;
        this.fontStyle = sVGNode.fontStyle;
        this.fontWeight = sVGNode.fontWeight;
        this.textAnchor = sVGNode.textAnchor;
        this.transform = new TinyTransform(sVGNode.transform);
        this.do = sVGNode.do;
        this.if = sVGNode.if;
        this.a = sVGNode.a;
    }

    public void addChild(SVGNode sVGNode, int n) {
        if (n < 0) {
            this.children.addElement(sVGNode);
        } else {
            this.children.insertElementAt(sVGNode, n);
        }
        sVGNode.parent = this;
        sVGNode.ownerDocument = this.ownerDocument;
        this.ownerDocument.do = true;
    }

    public int removeChild(int n) {
        int n2 = this.children.removeElementAt(n);
        if (n2 == 0) {
            this.ownerDocument.do = true;
        }
        return n2;
    }

    public abstract void paint(SVGRaster var1);

    public abstract int createOutline();

    public abstract SVGNode copyNode();

    public int setAttribute(int n, Object object) throws Exception {
        this.outlined = false;
        switch (n) {
            case 15: {
                this.color = (TinyColor)object;
                break;
            }
            case 25: {
                this.fill = (TinyColor)object;
                break;
            }
            case 27: {
                this.fillRule = ((TinyNumber)object).val;
                break;
            }
            case 82: {
                this.stroke = (TinyColor)object;
                break;
            }
            case 83: {
                this.strokeDashArray = (int[])object;
                break;
            }
            case 84: {
                this.strokeDashOffset = ((TinyNumber)object).val;
                break;
            }
            case 85: {
                this.strokeLineCap = ((TinyNumber)object).val;
                break;
            }
            case 86: {
                this.strokeLineJoin = ((TinyNumber)object).val;
                break;
            }
            case 87: {
                this.strokeMiterLimit = ((TinyNumber)object).val;
                break;
            }
            case 89: {
                this.strokeWidth = ((TinyNumber)object).val;
                break;
            }
            case 16: {
                break;
            }
            case 26: {
                this.fillOpacity = ((TinyNumber)object).val;
                break;
            }
            case 88: {
                this.strokeOpacity = ((TinyNumber)object).val;
                break;
            }
            case 56: {
                this.opacity = ((TinyNumber)object).val;
                break;
            }
            case 78: {
                this.stopColor = (TinyColor)object;
                break;
            }
            case 79: {
                this.stopOpacity = ((TinyNumber)object).val;
                break;
            }
            case 22: {
                this.display = ((TinyNumber)object).val;
                break;
            }
            case 106: {
                this.visibility = ((TinyNumber)object).val;
                break;
            }
            case 28: {
                this.fontFamily = (TinyString)object;
                break;
            }
            case 29: {
                this.fontSize = ((TinyNumber)object).val;
                break;
            }
            case 31: {
                break;
            }
            case 33: {
                break;
            }
            case 92: {
                this.textAnchor = ((TinyNumber)object).val;
                break;
            }
            case 94: {
                this.transform = (TinyTransform)object;
                break;
            }
            case 90: {
                this.a = (TinyString)object;
                break;
            }
            case 68: {
                this.if = (TinyString)object;
                break;
            }
            case 69: {
                this.do = (TinyString)object;
                break;
            }
            case 44: {
                this.id = (TinyString)object;
                break;
            }
            case 122: {
                this.xmlSpace = ((TinyNumber)object).val;
                break;
            }
            default: {
                return 8;
            }
        }
        return 0;
    }

    public Object getAttribute(int n) {
        int n2 = 0;
        Object object = null;
        switch (n) {
            case 15: {
                object = this.color;
                break;
            }
            case 25: {
                object = this.fill;
                break;
            }
            case 27: {
                n2 = this.fillRule;
                break;
            }
            case 82: {
                object = this.stroke;
                break;
            }
            case 83: {
                object = this.strokeDashArray;
                break;
            }
            case 84: {
                n2 = this.strokeDashOffset;
                break;
            }
            case 85: {
                n2 = this.strokeLineCap;
                break;
            }
            case 86: {
                n2 = this.strokeLineJoin;
                break;
            }
            case 87: {
                n2 = this.strokeMiterLimit;
                break;
            }
            case 89: {
                n2 = this.strokeWidth;
                break;
            }
            case 16: {
                break;
            }
            case 26: {
                n2 = this.fillOpacity;
                break;
            }
            case 88: {
                n2 = this.strokeOpacity;
                break;
            }
            case 56: {
                n2 = this.opacity;
                break;
            }
            case 78: {
                object = this.stopColor;
                break;
            }
            case 79: {
                n2 = this.strokeOpacity;
                break;
            }
            case 22: {
                n2 = this.display;
                break;
            }
            case 106: {
                n2 = this.visibility;
                break;
            }
            case 28: {
                object = this.fontFamily;
                break;
            }
            case 29: {
                n2 = this.fontSize;
                break;
            }
            case 31: {
                break;
            }
            case 33: {
                break;
            }
            case 92: {
                n2 = this.textAnchor;
                break;
            }
            case 94: {
                object = this.transform;
                break;
            }
            case 90: {
                object = this.a;
                break;
            }
            case 68: {
                object = this.if;
                break;
            }
            case 69: {
                object = this.do;
                break;
            }
            case 44: {
                object = this.id;
                break;
            }
            case 122: {
                n2 = this.xmlSpace;
                break;
            }
            default: {
                return null;
            }
        }
        if (object != null) {
            return object;
        }
        return new TinyNumber(n2);
    }

    public boolean matchUserAgent() {
        if (this.a != null) {
            return TinyString.compareTo(this.a.data, 0, this.a.count, "en".toCharArray(), 0, 2) == 0;
        }
        if (this.do != null) {
            return true;
        }
        return this.if == null;
    }

    public TinyColor getCurrentColor() {
        if (this.color != TinyColor.INHERIT) {
            return this.color;
        }
        return this.parent != null ? this.parent.getCurrentColor() : TinyColor.INHERIT;
    }

    public TinyColor getFillColor() {
        if (this.fill == TinyColor.CURRENT) {
            return this.getCurrentColor();
        }
        if (this.fill != TinyColor.INHERIT) {
            return this.resolveColor(this.fill);
        }
        return this.parent != null ? this.parent.getFillColor() : TinyColor.INHERIT;
    }

    public int getFillRule() {
        if (this.fillRule != 26) {
            return this.fillRule;
        }
        return this.parent != null ? this.parent.getFillRule() : 36;
    }

    public TinyColor getStrokeColor() {
        if (this.stroke == TinyColor.CURRENT) {
            return this.getCurrentColor();
        }
        if (this.stroke != TinyColor.INHERIT) {
            return this.resolveColor(this.stroke);
        }
        return this.parent != null ? this.parent.getStrokeColor() : TinyColor.INHERIT;
    }

    public TinyColor resolveColor(TinyColor tinyColor) {
        if (tinyColor.fillType != 5) {
            return tinyColor;
        }
        SVGNode sVGNode = SVGNode.getNodeById(this.ownerDocument.root, tinyColor.uri);
        if (sVGNode == null) {
            return tinyColor;
        }
        if (sVGNode.helem == 19 || sVGNode.helem == 26) {
            SVGGradientElem sVGGradientElem = (SVGGradientElem)sVGNode;
            if (!sVGGradientElem.outlined) {
                sVGGradientElem.createOutline();
            }
            return sVGGradientElem.gcolor;
        }
        return tinyColor;
    }

    public int[] getDashArray() {
        if (this.strokeDashArray != SVG.VAL_STROKEDASHARRAYINHERIT) {
            return this.strokeDashArray;
        }
        return this.parent != null ? this.parent.getDashArray() : SVG.VAL_STROKEDASHARRAYNONE;
    }

    public int getDashOffset() {
        if (this.strokeDashOffset != Integer.MIN_VALUE) {
            return this.strokeDashOffset;
        }
        return this.parent != null ? this.parent.getDashOffset() : 0;
    }

    public int getCapStyle() {
        if (this.strokeLineCap != 26) {
            return this.strokeLineCap;
        }
        return this.parent != null ? this.parent.getCapStyle() : 15;
    }

    public int getJoinStyle() {
        if (this.strokeLineJoin != 26) {
            return this.strokeLineJoin;
        }
        return this.parent != null ? this.parent.getJoinStyle() : 33;
    }

    public int getMiterLimit() {
        if (this.strokeMiterLimit != Integer.MIN_VALUE) {
            return this.strokeMiterLimit;
        }
        return this.parent != null ? this.parent.getMiterLimit() : 1024;
    }

    public int getLineThickness() {
        if (this.strokeWidth != Integer.MIN_VALUE) {
            return this.strokeWidth;
        }
        return this.parent != null ? this.parent.getLineThickness() : 256;
    }

    public int getFillOpacity() {
        if (this.fillOpacity != Integer.MIN_VALUE) {
            return this.fillOpacity;
        }
        return this.parent != null ? this.parent.getFillOpacity() : 255;
    }

    public int getStrokeOpacity() {
        if (this.strokeOpacity != Integer.MIN_VALUE) {
            return this.strokeOpacity;
        }
        return this.parent != null ? this.parent.getStrokeOpacity() : 255;
    }

    public int getOpacity() {
        if (this.opacity != Integer.MIN_VALUE) {
            return this.opacity;
        }
        return this.parent != null ? this.parent.getOpacity() : 255;
    }

    public TinyColor getStopColor() {
        if (this.stopColor == TinyColor.CURRENT) {
            return this.getCurrentColor();
        }
        if (this.stopColor != TinyColor.INHERIT) {
            return this.stopColor;
        }
        return this.parent != null ? this.parent.getStopColor() : TinyColor.INHERIT;
    }

    public int getStopOpacity() {
        if (this.stopOpacity != Integer.MIN_VALUE) {
            return this.stopOpacity;
        }
        return this.parent != null ? this.parent.getStopOpacity() : 256;
    }

    public int getDisplay() {
        if (this.display != 26) {
            return this.display;
        }
        return this.parent != null ? this.parent.getDisplay() : 27;
    }

    public int getVisibility() {
        if (this.visibility != 26) {
            return this.visibility;
        }
        return this.parent != null ? this.parent.getVisibility() : 58;
    }

    public int getFontSize() {
        if (this.fontSize != Integer.MIN_VALUE) {
            return this.fontSize;
        }
        return this.parent != null ? this.parent.getFontSize() : 3072;
    }

    public TinyString getFontFamily() {
        if (this.fontFamily != null) {
            return this.fontFamily;
        }
        return this.parent != null ? this.parent.getFontFamily() : SVG.VAL_DEFAULT_FONTFAMILY;
    }

    public int getTextAnchor() {
        if (this.textAnchor != 26) {
            return this.textAnchor;
        }
        return this.parent != null ? this.parent.getTextAnchor() : 54;
    }

    public boolean isVisible() {
        return this.getVisibility() == 58;
    }

    public boolean isDisplay() {
        return this.getDisplay() == 27;
    }

    public boolean contains(SVGRaster sVGRaster, TinyPoint tinyPoint) {
        TinyRect tinyRect = this.getDevBounds(sVGRaster);
        return tinyRect != null && tinyRect.contains(tinyPoint);
    }

    public boolean intersects(SVGRaster sVGRaster, TinyRect tinyRect) {
        TinyRect tinyRect2 = this.getDevBounds(sVGRaster);
        if (tinyRect2 == null) {
            return false;
        }
        return tinyRect2.intersects(tinyRect);
    }

    public SVGNode nodeHitAt(SVGRaster sVGRaster, TinyPoint tinyPoint) {
        if (this.isVisible() && this.getFillColor() != TinyColor.NONE && this.contains(sVGRaster, tinyPoint)) {
            return this;
        }
        return null;
    }

    public SVGNode seekAElem() {
        SVGNode sVGNode = this;
        while (sVGNode != null) {
            SVGNode sVGNode2 = sVGNode.parent;
            if (sVGNode2 != null && sVGNode2.helem == 0) {
                return sVGNode2;
            }
            sVGNode = sVGNode.parent;
        }
        return null;
    }

    public TinyMatrix getGlobalTransform() {
        SVGNode sVGNode = this;
        TinyMatrix tinyMatrix = new TinyMatrix();
        while (sVGNode != null) {
            if (sVGNode.transform != null) {
                tinyMatrix.concatenate(sVGNode.transform.matrix);
            }
            sVGNode = sVGNode.parent;
        }
        return tinyMatrix;
    }

    public TinyRect getBounds() {
        SVGNode sVGNode = this;
        if (!sVGNode.outlined || sVGNode.bounds == null) {
            sVGNode.createOutline();
        }
        return sVGNode.bounds;
    }

    public TinyRect getDevBounds(SVGRaster sVGRaster) {
        TinyRect tinyRect = this.getBounds();
        if (tinyRect == null) {
            return null;
        }
        TinyRect tinyRect2 = new TinyRect();
        TinyMatrix tinyMatrix = this.getGlobalTransform();
        tinyRect2 = sVGRaster.if.a(tinyMatrix, this.getLineThickness(), tinyRect);
        return tinyRect2;
    }

    public static SVGNode getNodeById(SVGNode sVGNode, TinyString tinyString) {
        if (sVGNode.id != null && tinyString != null && TinyString.compareTo(sVGNode.id.data, 0, sVGNode.id.count, tinyString.data, 0, tinyString.count) == 0) {
            return sVGNode;
        }
        int n = 0;
        while (n < sVGNode.children.count) {
            SVGNode sVGNode2 = (SVGNode)sVGNode.children.data[n];
            SVGNode sVGNode3 = SVGNode.getNodeById(sVGNode2, tinyString);
            if (sVGNode3 != null) {
                return sVGNode3;
            }
            ++n;
        }
        return null;
    }
}

